package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.UserStatusEnum;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.PatientBlockedHistory;
import gov.va.med.mhv.sm.model.PatientBlockedTriageGroup;
import gov.va.med.mhv.sm.model.PatientBlockedFacility;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.service.PatientBlockedService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.util.ValueComparator;
import gov.va.med.mhv.sm.web.session.BlockPatientSession;
import gov.va.med.mhv.sm.wsclient.queriessvc.PatientDemographics;
import gov.va.med.mhv.sm.wsclient.queriessvc._Address;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Locale;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.opensymphony.xwork2.Preparable;

public class BlockPatientAccess extends BaseSMAdminAction implements Preparable {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(BlockPatientAccess.class);

	private Administrator admin;
	private UserManagementService userManagementService;
	private PatientBlockedService patientBlockedService;
	private TriageGroupService triageGroupService;

	private static final String VISN = "visn";
	private static final String CANCEL = "cancel";

	private static final String BLOCKED = "Blocked";
	private static final String NOT_BLOCKED = "Not Blocked";

	private static final String BLOCK_PATIENT_SESSION = "block.patient.session";
	private static final String HAS_SEARCH_RESULTS = "has.search.results";
	private static final String HAS_SELECTED_PATIENT = "has.selected.patient";
	private static final String VISN_SELECTION_ACTION = "visn.selection.action";

	private static final String ACCESS_ALREADY_BLOCKED = "Status did not change; the patient's access is already blocked.";
	private static final String ACCESS_ALREADY_UNBLOCKED = "Status did not change; the patient's access is already unblocked.";
	private static final String REQUIRED_COMMENT = "You must enter a comment to save the status.";
	// struts fields
	private BlockPatientSession blockSession;
	private String firstName;
	private String lastName;
	private String nssn;
	private String blockSearchBtn;
	private String cancelBtn;
	private String submitStatusBtn;
	private String selectPatientBtn;
	private String selectVisnBtn;
	private String addBtn;
	private String removeBtn;
	private Long selectedPatientId;
	private Patient selectedPatient;
	private PatientDemographics demographics;
	private String blockedStatus;
	private static final List<String> blockedRadio;
	private String blockedReason;
	private Long facilityId;
	private Collection<Facility> visns;
	private Collection<Facility> facilities;
	private Long selectedVisn;
	private Long selectedFacility;
	private String selectedVisnName;
	private Long visnId;
	private String selectAction;
	private String previousComments;
	private Long patientCurrentStatus;
	private String changeStatusSelect;
	private String submitRadioBtn;
	private static final String SELECTED_TRIAGE_GROUPS="selectedTriageGroups";
	


	static{
		blockedRadio = new ArrayList<String>();
		blockedRadio.add(BLOCKED);
		blockedRadio.add(NOT_BLOCKED);
    }


	@SuppressWarnings("unchecked")
	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext.getServletContext());
		userManagementService = (UserManagementService) ctx.getBean("userManagementService");
		patientBlockedService = (PatientBlockedService) ctx.getBean("patientBlockedService");
		triageGroupService = (TriageGroupService) ctx.getBean("triageGroupService");

		if(getSessionAttribute(BLOCK_PATIENT_SESSION) == null) {
			blockSession = new BlockPatientSession();
			setSessionAttribute(BLOCK_PATIENT_SESSION, blockSession);
		}else{
			blockSession = (BlockPatientSession)getSessionAttribute(BLOCK_PATIENT_SESSION);
		}
		admin = (Administrator)getSessionAttribute(CURRENT_USER);

	}

	public String showVisn() {
		removeSessionAttr();
		return SUCCESS;
	}

	public String showFacilitiesInVisn() {

		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Cancel"))){
			removeSessionAttr();
			return CANCEL;
		}
		facilities = new TreeSet<Facility>();
		for(Facility v : getAdministeredVisns()){
			if(v.getId().equals(selectedVisn)){
				selectedVisnName = v.getName();
				facilities = getAdministeredFacilitiesInVisn(v);
			}
		}
		setSessionAttribute("selectedVisn",selectedVisn);
		setSessionAttribute("selectedVisnName",selectedVisnName);
		setSessionAttribute("facilities",facilities);
		blockSession.setFacilities(facilities);
		return SUCCESS;
	}

	public String selectVisn(){

		visns = getFacilityService().getVisnList().getCollection();

		if(visnId <= 0L){
			setAttribute(VISN_SELECTION_ACTION, "blockPatientAccessSubmit.action");
			addActionError("Please select a VISN");
			return VISN;
		}

		Facility visn = null;

		for(Facility v : visns){
			if(v.getId().equals(visnId)){
				visn = v;
				break;
			}
		}

		if(visn == null){
			addActionError("Please select a VISN");
			setAttribute(VISN_SELECTION_ACTION, "blockPatientAccessSubmit.action");
			return VISN;
		}

		blockSession.setSelectedVisn(visn);
		blockSession.setFacilities(getFacilityService().getFacilitiesForVisn(visn).getCollection());
		return SUCCESS;
	}

	public void removeSessionAttr(){
		removeSessionAttribute("facilities");
		removeSessionAttribute("selectedUsers");
		removeSessionAttribute("selectedVisn");
	}

	private String search(){
		Locale.setDefault(Locale.ENGLISH);
		if((facilityId == null) || (facilityId == -1)){
			addActionError("Please select a facility.");
			return SUCCESS;
		}

		if(StringUtils.isBlank(lastName) && StringUtils.isBlank(nssn)){
			addActionError("Last Name or First Letter of Last Name + Last 4 of SSN are required.");
			return SUCCESS;
		}

		Facility facility = null;

		for(Facility f : blockSession.getFacilities()){
			if(f.getId().equals(facilityId)){
				facility = f;
				break;
			}
		}

		if(facility == null){
			addActionError("Facility not found.");
			return SUCCESS;
		}
		blockSession.setSelectedFacility(facility);

		if(firstName !=null) firstName = firstName.trim();
		if(lastName !=null) lastName = lastName.trim();
		if(nssn !=null) nssn = nssn.trim();

		CollectionServiceResponse<Patient> response =
				userManagementService.searchForPatients(firstName, lastName, nssn, facility.getStationNumber());

		Collection<Patient> collectionPatient = new TreeSet<Patient>(PATIENT_BY_NAME_COMPARATOR); // fix for CQ# 5163
		collectionPatient.addAll(response.getCollection());

		blockSession.setPatients(collectionPatient);
		if(blockSession.getPatients() == null || blockSession.getPatients().size() == 0){
			addActionError("No Results Returned.");
			setAttribute(HAS_SEARCH_RESULTS, Boolean.FALSE);
			return SUCCESS;
		}

		setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);

		return SUCCESS;
	}


	public String select(){

		/*
		 * Validation for the Bug#5748, the validation triggers when the user choose default option 'Select a Patient' in the drop down.
		 */
		if(selectedPatientId == -1){
			addActionError("Please select a patient.");
			setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);
			return SUCCESS;
		}

		for(Patient p : blockSession.getPatients()){
			if(p.getId().equals(selectedPatientId)){
				selectedPatient = p;
				break;
			}
		}

		if(selectedPatient == null){
			addActionError("Unable to identify patient");
			return SUCCESS;
		}


		setPatientCurrentStatus(selectedPatient.getStatus().getId());
		getSession().setAttribute(SELECTED_TRIAGE_GROUPS, null);
	    setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);
		setAttribute(HAS_SELECTED_PATIENT, Boolean.TRUE);
		blockSession.setSelectedPatient(selectedPatient);
		displaySelectedPatientInfo();

		/********* End Format for display of Zipcodes - CR#4789 ***************/

		return SUCCESS;

	}

	private void displayPatientDemographics(){
		selectedPatient = blockSession.getSelectedPatient();
		ServiceResponse<PatientDemographics> resDemo = userManagementService.getPatientDemographics(
				selectedPatient.getSsn(),
				blockSession.getSelectedFacility().getStationNumber());

		if(handleErrorMessages(resDemo.getMessages())){
			demographics = new PatientDemographics();
			demographics.setHomeAddress(new _Address());
		}else{
			demographics = resDemo.getPayload();
		}
		String formattedZipCode = "";
		if(null != resDemo.getPayload())
		{
			if(demographics.getHomeAddress()!=null && demographics.getHomeAddress().getAddress() !=null && demographics.getHomeAddress().getAddress().getZipCode() !=null){
				formattedZipCode =   demographics.getHomeAddress().getAddress().getZipCode(); // eg. "201711234"
				if(formattedZipCode.length() > 5 && !StringUtils.contains(formattedZipCode,"-")){
					formattedZipCode = formattedZipCode.substring(0,5)+"-"+formattedZipCode.substring(5,formattedZipCode.length());
				}
			}
		}
		blockSession.setFormattedZipCode(formattedZipCode);
	}

	private void displaySelectedPatientInfo(){
		displayPatientDemographics();
		selectedPatient = blockSession.getSelectedPatient();
		setPreviousComments(getPreviousPatientComments(new Long(selectedPatient.getId())));
	}

	private String selectUserOption()
	{
		setChangeStatusSelect(changeStatusSelect);
		displaySelectedPatientInfo();
		setPatientCurrentStatus(selectedPatient.getStatus().getId());
	    setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);
		setAttribute(HAS_SELECTED_PATIENT, Boolean.TRUE);
		return SUCCESS;
	}

	/*
	 * Comparator to Compare the Patient object for the Sorting order implementation (CQ# 5163)
	 */
	public static final Comparator<Patient> PATIENT_BY_NAME_COMPARATOR = new Comparator<Patient>() {
		public int compare(Patient a, Patient b) {
			if(a == null || b == null) return 0;
			int result = (a.getLastName().toUpperCase()).compareTo(b.getLastName().toUpperCase());
			if ( result == 0 ) {
				result = a.getFirstName().toUpperCase().compareTo(b.getFirstName().toUpperCase());
			}
			return result;
		}
	};

	public static final Comparator<TriageGroup> GROUP_NAME_COMPARATOR = new Comparator<TriageGroup>() {
		public int compare(TriageGroup a, TriageGroup b) {
			if(a == null || b == null) return 0;
			int result = (a.getName().toUpperCase()).compareTo(b.getName().toUpperCase());
			if ( result == 0 ) {
				result = a.getName().toUpperCase().compareTo(b.getName().toUpperCase());
			}
			return result;
		}
	};

	private String changeStatus(){

		Patient p = blockSession.getSelectedPatient();

		// reset the attribute on the chance of error
		setAttribute(HAS_SELECTED_PATIENT, Boolean.TRUE);
		selectedPatient = p;

		if(p == null){
			addActionError("Patient not selected");
			return SUCCESS;
		}

		// action was changed, is there a reason
		if(StringUtils.isBlank(blockedReason)){
			  setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);	 // Search results should appear in the screen with the error message (CQ: 5536).
			  setAttribute(HAS_SELECTED_PATIENT, Boolean.TRUE);  // Selected patient should appear in the screen with error message (CQ: 5536).
			  displaySelectedPatientInfo();
			  addActionError(REQUIRED_COMMENT);
			return SUCCESS;
		}

		boolean changed = false;

		if(log.isInfoEnabled()){
			log.info("BlockPatientAccess->------------------------------------------------------------------------");
			log.info("BlockPatientAccess->Change Status......"+getChangeStatusSelect());
			log.info("BlockPatientAccess->Selected Triage Groups from Session........."+getSession().getAttribute(SELECTED_TRIAGE_GROUPS));
			log.info("BlockPatientAccess->Current User......"+getCurrentUser().getId());
			log.info("BlockPatientAccess->Selected Patient...."+p.getId());
		}
		PatientBlockedHistory patientBlockedHistory = new PatientBlockedHistory();;
		patientBlockedHistory.setComments(getBlockedReason().trim().length()>500?getBlockedReason().trim().substring(0,500):getBlockedReason().trim());
		patientBlockedHistory.setPatientId(p.getId());
		patientBlockedHistory.setUserId(getCurrentUser().getId());

		Long stationNumber = new Long(blockSession.getSelectedFacility().getStationNumber());
		patientBlockedHistory.setStationNumber(stationNumber);
		if(getChangeStatusSelect().equals("5")){
			try{
				patientBlockedHistory.setPatientStatus(UserStatusEnum.BLOCKED_FROM_TRIAGE_GROUP);
				patientBlockedHistory.setTriageGroupIds(getSession().getAttribute(SELECTED_TRIAGE_GROUPS).toString());
				List patientBlockedTgList = new ArrayList();
				Map<Long,String> selectedMap = (Map)getSession().getAttribute(SELECTED_TRIAGE_GROUPS);
				for (Map.Entry<Long, String> entry : selectedMap.entrySet()){
					PatientBlockedTriageGroup patBlockedTriageGroup = new PatientBlockedTriageGroup();
					patBlockedTriageGroup.setTriageGroupId(entry.getKey());
					patBlockedTriageGroup.setPatientId(p.getId());
					patBlockedTriageGroup.setStationNumber(stationNumber);
					patBlockedTriageGroup.setUserId(getCurrentUser().getId());
					patBlockedTriageGroup.setBlocked(true);
					patientBlockedTgList.add(patBlockedTriageGroup);
				}
				patientBlockedService.clearPatientBlockedTriageGroupByPatientIdAndStation(p.getId(),stationNumber);
				Boolean updatedStatus = patientBlockedService.updateBlockedPatientTriageGroups(patientBlockedTgList).getPayload();
				if(log.isInfoEnabled()){
					log.info("------------------------------------------------------------------------Updated Status"+updatedStatus);
				}
				if(updatedStatus){
					patientBlockedService.updateBlockedPatientHistory(patientBlockedHistory);
				}else{
					if(log.isErrorEnabled()){
						log.error("BlockPatientAccess->An Error Occured while processing your request, please try again later.");
					}
					addActionError("BlockPatientAccess->An Error Occured while processing your request, please try again later.");
				}
			}catch(Exception one){
				if(log.isErrorEnabled()){
					log.error("<<<<<<<1000-E1>>>>An Error Occured while block patient from TG."+one);
				}
			}


		}else if(getChangeStatusSelect().equals("2")){
			try{
				patientBlockedHistory.setPatientStatus(UserStatusEnum.BLOCKED_FROM_FACILITY);
				//patientBlockedService.clearPatientBlockedTriageGroupByPatientId(p.getId());   // Jazz Story #155629 - clear only from the selected facility. need to pass station number.
				patientBlockedService.clearPatientBlockedTriageGroupByPatientIdAndStation(p.getId(),stationNumber);
				patientBlockedService.updateBlockedPatientHistory(patientBlockedHistory);
				//userManagementService.blockPatient(p, admin, getBlockedReason());		// Jazz Story #155629 - No more Block patient from SM. Instead  block from Facility.
				PatientBlockedFacility patientBlockedFacility = new PatientBlockedFacility();
				patientBlockedFacility.setPatientId(p.getId());
				patientBlockedFacility.setStationNumber(stationNumber);
				patientBlockedFacility.setUserId(getCurrentUser().getId());
				patientBlockedFacility.setBlocked(true);
				patientBlockedService.saveBlockedPatientFacility(patientBlockedFacility);
				if(log.isInfoEnabled()){
					log.info("BlockPatientAccess->Patient Blocked to SM Successfully ");
				}
			}catch(Exception  two){
				if(log.isInfoEnabled()){
					log.error("<<<<<<<1000-E2>>>>An Error Occured while block patient from System."+two);
				}
			}

		}else if(getChangeStatusSelect().equals("2A")){
			try{
				patientBlockedHistory.setPatientStatus(UserStatusEnum.UNBLOCKED_FROM_FACILITY);
				//patientBlockedService.clearPatientBlockedTriageGroupByPatientId(p.getId());		// Jazz Story #155629 - clear only from the selected facility. need to pass station number.
				patientBlockedService.clearPatientBlockedTriageGroupByPatientIdAndStation(p.getId(),stationNumber);
				patientBlockedService.updateBlockedPatientHistory(patientBlockedHistory);
				//userManagementService.unblockPatient(p, admin, getBlockedReason());   	 // Jazz Story #155629 - No more Block/unblock patient from SM. Instead  unblock from Facility.
				patientBlockedService.clearPatientBlockedFacilityByPatientIdAndStation(p.getId(),stationNumber);
				if(log.isInfoEnabled()){
					log.info("BlockPatientAccess->Patient Un-Blocked from SM Successfully ");
				}
			}catch(Exception three){
				if(log.isErrorEnabled()){
					log.error("<<<<<<<1000-E3>>>>An Error Occured while un block patient System"+three);
				}
			}
		}

		addActionError("User status changed successfully.");

		// clean up the session
		blockSession = new BlockPatientSession();

		return CANCEL;
	}


	public String submit(){

		if(!StringUtils.isBlank(cancelBtn)){
			return CANCEL;
		}

		if(!StringUtils.isBlank(blockSearchBtn)){
			return search();
		}

		if(!StringUtils.isBlank(selectPatientBtn)){
			return select();
		}

		if(!StringUtils.isBlank(selectVisnBtn)){
			return selectVisn();
		}

		if(!StringUtils.isBlank(submitRadioBtn)){
			return selectUserOption();
		}


		if(!StringUtils.isBlank(submitStatusBtn)){
			return changeStatus();
		}
		if (!StringUtils.isBlank(addBtn)){
			addTriageGroups(this.getParameterValueList("triageGroupsToAdd"));
			displaySelectedPatientInfo();
			setPatientCurrentStatus(selectedPatient.getStatus().getId());
		    setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);
			setAttribute(HAS_SELECTED_PATIENT, Boolean.TRUE);
			return SUCCESS;
		}

		if (!StringUtils.isBlank(removeBtn)){
			removeTriageGroups(this.getParameterValueList("triageGroupsToRemove"));
			displaySelectedPatientInfo();
			setPatientCurrentStatus(selectedPatient.getStatus().getId());
		    setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);
			setAttribute(HAS_SELECTED_PATIENT, Boolean.TRUE);
			return SUCCESS;
		}


		addActionError("Unknown action!");
		return SUCCESS;

	}



	public String getPreviousPatientComments(Long patientId){

		StringBuffer prevComments = new StringBuffer();
		List<Object[]> prevCommentsList = patientBlockedService.getPatientBlockedCommentsByPatientId(patientId);
		if(prevCommentsList!=null)
		{
			for(Object[] object : prevCommentsList)
			{
				prevComments.append(object[0].toString());
				prevComments.append(" ");
				prevComments.append(object[2].toString());
				prevComments.append(", ").append(object[3].toString());
				prevComments.append(" - ");
				prevComments.append(object[1].toString());
				prevComments.append("<br>");
			}
		}

		return prevComments.toString();
	}


   public Map<Long,String> getSelectedTriageGroups(){
	   Map resultsMap = null;
	   if(getSession().getAttribute(SELECTED_TRIAGE_GROUPS)!=null){
		   if(log.isInfoEnabled()){
			   log.info("400->getSessionAttribute is not empty......");
		   }
		   resultsMap = (Map)getSession().getAttribute(SELECTED_TRIAGE_GROUPS);
	   }else{
		    if(log.isInfoEnabled()){
		    	log.info("500->getSessionAttribute is empty fetching from DB......");
		    }
		    resultsMap = new HashMap<Long,String>();
		    Long stationNumber =  new Long(blockSession.getSelectedFacility().getStationNumber());
			List<Object[]> list = patientBlockedService.getPatientBlockedTriageGroupsByPatientIdAndStation(selectedPatient.getId(),stationNumber);
			for(Object[] obj:list)
			{
				Long tgId = ((BigDecimal)obj[2]).longValue();
				resultsMap.put(tgId, obj[1].toString());
			}
			getSession().setAttribute(SELECTED_TRIAGE_GROUPS, resultsMap);
	   }
	   return sortMapByValue(resultsMap);
   }


	private void addTriageGroups(Collection<String> idStrings) {
		if(log.isInfoEnabled()){
			log.info("300-> TG Ids to Add...."+idStrings);
		}
		Map<Long, String> selectedMap = (Map)getSession().getAttribute(SELECTED_TRIAGE_GROUPS);
		for(String idStr : idStrings) {
			Long id = Long.parseLong(idStr);
			if(log.isInfoEnabled()){
				log.info("300A->Selected Id......."+id);
			}
			for (Map.Entry<Long, String> entry : getAllPatientTriageGroupsMap().entrySet()){
				if(log.isInfoEnabled()){
					log.info("300B->Key from DB*********************"+entry.getKey());
				}
				if(id.equals(entry.getKey())){
					if(log.isInfoEnabled()){
						log.info("300C-> Id matching with Orig Id.....So adding to selectedMap"+entry.getKey()+"^"+entry.getValue());
					}
					selectedMap.put(entry.getKey(),entry.getValue());
					break;
				}
			}
		}
		getSession().setAttribute(SELECTED_TRIAGE_GROUPS, selectedMap);
	}

	private void removeTriageGroups(Collection<String> idStrings) {
		if(log.isInfoEnabled()){
			log.info("700-> TG Ids to Remove...."+idStrings);
		}
		Map<Long, String> selectedMap = (Map)getSession().getAttribute(SELECTED_TRIAGE_GROUPS);
		for(String idStr : idStrings) {
			Long id = Long.parseLong(idStr);
			if(log.isInfoEnabled()){
				log.info("700A->Selected Id......."+id);
			}
			for (Map.Entry<Long, String> entry : selectedMap.entrySet()){
				if(id.equals(entry.getKey())){
					if(log.isInfoEnabled()){
						log.info("700C-> Id matching with Session Id.....So remove from  selectedMap"+entry.getKey()+"^"+entry.getValue());
					}
					selectedMap.remove(entry.getKey());
					break;
				}
			}
		}
		getSession().setAttribute(SELECTED_TRIAGE_GROUPS, selectedMap);
	}

	public  Map sortMapByValue(Map unsortedMap){
	    Map sortedMap = new TreeMap(new ValueComparator(unsortedMap));
	    sortedMap.putAll(unsortedMap);
	    return sortedMap;
	}

	public Collection<TriageGroup> getPatientTriageGroupsCollection() {
		Locale.setDefault(Locale.ENGLISH);
		Collection<TriageGroup> result = new TreeSet<TriageGroup>(GROUP_NAME_COMPARATOR);
		CollectionServiceResponse<TriageGroup> response = triageGroupService.getTriageGroupsForPatientByStation(selectedPatient, blockSession.getSelectedFacility().getStationNumber());
		result.addAll(response.getCollection());

	    try
	    {
	    	Map selectedMap = getSelectedTriageGroups();
	    	for (Object key : selectedMap.keySet()){
	    		Long tgId = (Long)key;
	    		for(TriageGroup origTriageGroup:result){
					if(origTriageGroup.getId().equals(tgId)){
						if(log.isInfoEnabled()){
							log.info("100->Matching Triage Group Id.."+origTriageGroup.getId());
						}
						result.remove(origTriageGroup);
						if(log.isInfoEnabled()){
							log.info("200->After Removed selected from Orig List......");
						}
						break;
					}
				}
	    	}
	    }catch(Exception e1){
	    	if(log.isErrorEnabled()){
	    		log.error("Error inside Object[]"+e1);
	    	}
	    }
		return result;
	}

	protected Map<Long, String> getAllPatientTriageGroupsMap() {
		Map<Long, String> result = new HashMap<Long, String>();
		CollectionServiceResponse<TriageGroup> response = triageGroupService.getTriageGroupsForPatientByStation(blockSession.getSelectedPatient(), blockSession.getSelectedFacility().getStationNumber());
		Collection<TriageGroup> triageGroups = response.getCollection();
		for(TriageGroup tg : triageGroups) {
			result.put(tg.getId(), tg.getName());
		}
		return result;
	}

	public UserStatusEnum getCurrentStatus(){

		// Find if the patient is blocked from facility and set it to BLOCKED_FROM_FACILITY
		List<Object[]> patientBlockedFacilityList = patientBlockedService.getPatientBlockedFacilityByPatientIdAndStation(selectedPatient.getId(),new Long(blockSession.getSelectedFacility().getStationNumber()));
		if(patientBlockedFacilityList!=null && patientBlockedFacilityList.size()!=0){
			return UserStatusEnum.BLOCKED_FROM_FACILITY;
		}else
		// Jazz Story #155629 - get the status from facility table -
		//Patient selectedPatient = blockSession.getSelectedPatient();
		//if(selectedPatient.getStatus().equals(UserStatusEnum.BLOCKED_FROM_FACILITY))
		//{
		//	return UserStatusEnum.BLOCKED_FROM_FACILITY;
		//}else
		{
			List<Object[]> patientBlockedTgList = patientBlockedService.getPatientBlockedTriageGroupsByPatientIdAndStation(selectedPatient.getId(),new Long(blockSession.getSelectedFacility().getStationNumber()));
			if(patientBlockedTgList!=null && patientBlockedTgList.size()!=0){
				return UserStatusEnum.BLOCKED_FROM_TRIAGE_GROUP;
			}
		}
		return UserStatusEnum.UNBLOCKED_FROM_FACILITY;
	}


	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getNssn() {
		return nssn;
	}
	public void setNssn(String nssn) {
		this.nssn = nssn;
	}
	public String getBlockSearchBtn() {
		return blockSearchBtn;
	}
	public void setBlockSearchBtn(String blockSearchBtn) {
		this.blockSearchBtn = blockSearchBtn;
	}
	public String getCancelBtn() {
		return cancelBtn;
	}
	public void setCancelBtn(String cancelBtn) {
		this.cancelBtn = cancelBtn;
	}
	public Long getSelectedPatientId() {
		return selectedPatientId;
	}
	public void setSelectedPatientId(Long selectedPatientId) {
		this.selectedPatientId = selectedPatientId;
	}
	public String getSelectPatientBtn() {
		return selectPatientBtn;
	}
	public void setSelectPatientBtn(String selectPatientBtn) {
		this.selectPatientBtn = selectPatientBtn;
	}
	public Patient getSelectedPatient() {
		return selectedPatient;
	}
	public void setSelectedPatient(Patient selectedPatient) {
		this.selectedPatient = selectedPatient;
	}
	public PatientDemographics getDemographics() {
		return demographics;
	}
	public void setDemographics(PatientDemographics demographics) {
		this.demographics = demographics;
	}
	public String getBlockedStatus() {
		return blockedStatus;
	}
	public void setBlockedStatus(String blockedStatus) {
		this.blockedStatus = blockedStatus;
	}
	public static List<String> getBlockedRadio() {
		return blockedRadio;
	}
	public String getSubmitStatusBtn() {
		return submitStatusBtn;
	}
	public void setSubmitStatusBtn(String submitStatusBtn) {
		this.submitStatusBtn = submitStatusBtn;
	}
	public String getBlockedReason() {
		return blockedReason;
	}
	public void setBlockedReason(String blockedReason) {
		this.blockedReason = blockedReason;
	}
	public Long getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(Long facilityId) {
		this.facilityId = facilityId;
	}
	public Collection<Facility> getVisns() {
		return visns;
	}
	public void setVisns(Collection<Facility> visns) {
		this.visns = visns;
	}
	public Long getVisnId() {
		return visnId;
	}
	public void setVisnId(Long visnId) {
		this.visnId = visnId;
	}

	public BlockPatientSession getBlockSession() {
		return blockSession;
	}

	public void setBlockSession(BlockPatientSession blockSession) {
		this.blockSession = blockSession;
	}
	public String getSelectVisnBtn() {
		return selectVisnBtn;
	}
	public void setSelectVisnBtn(String selectVisnBtn) {
		this.selectVisnBtn = selectVisnBtn;
	}

	public Collection<Facility> getFacilities() {
		return facilities;
	}

	public void setFacilities(Collection<Facility> facilities) {
		this.facilities = facilities;
	}

	public Long getSelectedVisn() {
		return selectedVisn;
	}

	public void setSelectedVisn(Long selectedVisn) {
		this.selectedVisn = selectedVisn;
	}

	public Long getSelectedFacility() {
		return selectedFacility;
	}

	public void setSelectedFacility(Long selectedFacility) {
		this.selectedFacility = selectedFacility;
	}

	public String getSelectAction() {
		return selectAction;
	}

	public void setSelectAction(String selectAction) {
		this.selectAction = selectAction;
	}

	public String getSelectedVisnName() {
		return selectedVisnName;
	}

	public void setSelectedVisnName(String selectedVisnName) {
		this.selectedVisnName = selectedVisnName;
	}
	public String getPreviousComments() {
		return previousComments;
	}

	public void setPreviousComments(String previousComments) {
		this.previousComments = previousComments;
	}

	public Long getPatientCurrentStatus() {
		return patientCurrentStatus;
	}

	public void setPatientCurrentStatus(Long patientCurrentStatus) {
		this.patientCurrentStatus = patientCurrentStatus;
	}

	public String getChangeStatusSelect() {
		return changeStatusSelect;
	}

	public void setChangeStatusSelect(String changeStatusSelect) {
		this.changeStatusSelect = changeStatusSelect;
	}

	public String getSubmitRadioBtn() {
		return submitRadioBtn;
	}

	public void setSubmitRadioBtn(String submitRadioBtn) {
		this.submitRadioBtn = submitRadioBtn;
	}

	public String getAddBtn() {
		return addBtn;
	}

	public void setAddBtn(String addBtn) {
		this.addBtn = addBtn;
	}

	public String getRemoveBtn() {
		return removeBtn;
	}

	public void setRemoveBtn(String removeBtn) {
		this.removeBtn = removeBtn;
	}
}
